/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.Drawing;

using Borland.Eco.Services;
using Borland.Eco.Persistence;
using Borland.Eco.Globalization;

namespace Borland.Eco.Persistence
{
	[ToolboxItem(true)]
	[ToolboxBitmap(typeof(PersistenceMapperSharer), "Borland.Eco.Persistence.PersistenceMapperSharer.bmp")]
	public class PersistenceMapperSharer: PersistenceMapper
	{
		private System.Type m_MapperProviderType;
		private int m_UseCount;

		///<exception cref="InvalidOperationException">Thrown if trying to set the property when the sharing has started.</exception>
		[LocalizableCategory(typeof(PersistenceStringRes), "sMapping")]
		[LocalizableDescription(typeof(PersistenceStringRes), "sMapperProviderType")]
		[TypeConverter("Borland.Eco.Persistence.Design.PersistenceMapperProviderTypeTypeConverter, Borland.Eco.Persistence.Design")]
		[DefaultValue(null)]
		public System.Type MapperProviderType
		{
			get { return  m_MapperProviderType; }
			set
			{
				lock(this)
				{
					if (m_UseCount != 0)
						throw new InvalidOperationException(PersistenceStringRes.sSharerInUse);
					m_MapperProviderType = value;
				}
			}
		}

		public override IPersistenceMapper GetPersistenceMapper(ITypeSystemService typeSystemService)
		{
			lock(this)
			{
				m_UseCount++;
				return PersistenceMapperProvider.GetInstance(MapperProviderType).GetPersistenceMapper(typeSystemService);
			}
		}

		public override void ReturnPersistenceMapper(IPersistenceMapper persistenceMapper)
		{
			lock(this)
			{
				PersistenceMapperProvider.GetInstance(m_MapperProviderType).ReturnPersistenceMapper(persistenceMapper);
				m_UseCount--;
			}
		}
	}
}
